//
//  GHDeviceSchema.h
//  Garmin Health
//
//  Created by Johnson, Garrett on 6/3/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import "GHDeviceTypes.h"

/**
 *  Class exposing which settings the device supports. You can use the values provided by this class
 *  to define your UI for each particular Garmin device your app will support.
 */
@interface GHDeviceSchema : NSObject <NSCoding>

/** Type of device. Refer to GHDeviceTypes for more information. */
@property (nonatomic, readonly) GHDeviceTypes type;

/** Indicates if the device supports a default screen. */
@property (nonatomic, readonly) BOOL supportsDefaultScreen;

/** Array of supported display orientations id numbers. */
@property (nonatomic, readonly) NSArray<NSNumber*> *supportedDisplayOrientations;

/** Array of supported goal type id numbers. */
@property (nonatomic, readonly) NSArray<NSNumber*> *supportedGoals;

/** Array of supported backlight option id numbers */
@property (nonatomic, readonly) NSArray<NSNumber*> *supportedBacklightSettings;

/** Array of supported watch face id numbers */
@property (nonatomic, readonly) NSArray<NSNumber*> *supportedWatchFaces;

/** Array of supported screen mode id numbers */
@property (nonatomic, readonly) NSArray<NSNumber*> *supportedScreenModes;

/** Array of supported heart rate option id numbers */
@property (nonatomic, readonly) NSArray<NSNumber*> *supportedHeartRateModes;

/** Indicates if the device supports the auto uploading of data to app. */
@property (nonatomic, readonly) BOOL supportsAutoUpload;

/** Indicates if the device supports setting frequency for auto sync. */
@property (nonatomic, readonly) BOOL supportsAutoSyncFrequency;

/** Indicates if the device supports autodetecting activities - MoveIQ. */
@property (nonatomic, readonly) BOOL supportsActivityDetectedAlert;

/** Indicates if the device supports a custom message screen. */
@property (nonatomic, readonly) BOOL supportsCustomMessageScreen;

/** Indicates if the device supports move alerts. */
@property (nonatomic, readonly) BOOL supportsMoveAlert;

/** Indicates if the device supports low SpO2 alerts. */
@property (nonatomic, readonly) BOOL supportsSpO2Alert;

/** Indicates if the device supports abnormal heart rate alerts. */
@property (nonatomic, readonly) BOOL supportsAbnormalHeartRateAlert;

/** Indicates if the device supports push notification alerts. */
@property (nonatomic, readonly) BOOL supportsPushNotificationAlert;

/** Indicates if the device supports goal reached alerts. */
@property (nonatomic, readonly) BOOL supportsGoalAlert;

/** Indicates if the device supports stress alerts. */
@property (nonatomic, readonly) BOOL supportsStressAlert;

/** Indicates if the device supports hourly chime alerts. */
@property (nonatomic, readonly) BOOL supportsHourlyChimeAlert;

/** Indicates if the device supports hydration alerts. */
@property (nonatomic, readonly) BOOL supportsHydrationAlert;

/** NS_UNAVAILABLE */
+ (instancetype)new NS_UNAVAILABLE;

/** NS_UNAVAILABLE */
- (instancetype)init NS_UNAVAILABLE;


@end
